<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

error_log("Cron started at " . date('Y-m-d H:i:s'));

// Setting up the time zone
date_default_timezone_set('Asia/Kolkata');

// Host Name
$dbhost = 'localhost';
 
$dbname = 'fmslogistics_venus_cargo';
$dbuser = 'fmslogistics_venus_cargo';
$dbpass = 'fmslogistics_venus_cargo';
define("BASE_URL", "https://venus-cargo.fms-logistics.in.net/admin-new/");


// Getting Admin url
define("ADMIN_URL", BASE_URL . "admin" . "/");

try {
	$pdo = new PDO("mysql:host={$dbhost};dbname={$dbname}", $dbuser, $dbpass);
	$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	ini_set('memory_limit', '2048M');
	$statement = $pdo->prepare("SET SESSION sql_mode = ''");
	$statement->execute();
}
catch( PDOException $exception ) {
	echo "Connection error :" . $exception->getMessage();
}


function get_random_string($valid_chars, $length)
    {

        // start with an empty random string
        $random_string = "";

        // count the number of chars in the valid chars string so we know how many choices we have
        $num_valid_chars = strlen($valid_chars);

        // repeat the steps until we've created a string of the right length
        for ($i = 0; $i < $length; $i++) {
            // pick a random number from 1 up to the number of valid chars
            $random_pick = mt_rand(1, $num_valid_chars);

            // take the random character out of the string of valid chars
            // subtract 1 from $random_pick because strings are indexed starting at 0, and we started picking at 1
            $random_char = $valid_chars[$random_pick - 1];

            // add the randomly-chosen char onto the end of our string so far
            $random_string .= $random_char;
        }

        // return our finished random string
        return $random_string;
    } // end of get_random_string()
    
function RandomString(){
    
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randstring = '';
        for ($i = 0; $i < 5; $i++) {
            $randstring.= $characters[rand(0, strlen($characters))];
        }
        return $randstring;
    }
    
    
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        // IP from shared internet
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        // IP passed from proxy
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        // Direct IP address
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}


$statement = $pdo->prepare("SELECT * FROM api_auth_details where id = 2");
$statement->execute();
$auth_data = $statement->fetch(PDO::FETCH_ASSOC);

$authgstin = $auth_data['gstin'];
$authpassword = $auth_data['password'];
$authemail = $auth_data['email'];
$authusername = $auth_data['username'];
// $authip_address = $auth_data['ip_address'];
$authclient_id = $auth_data['client_id'];
$authclient_secret = $auth_data['client_secret'];
$authip_address = getUserIP() ?? '192.168.1.100'; 
// $baseUrl = "https://apisandbox.whitebooks.in";
$baseUrl = "https://api.whitebooks.in";

try {
    
    // $date=date('d/m/Y');
    $date='08/06/2025';

    /*$stmt = $pdo->prepare("
             SELECT 
                br.name AS branch_name,
                br.state_code,
                pk.shipper_name,
                pk.shipper_pincode,
                e.ewbNo,
                e.delPinCode,
                e.delStateCode,
                s.name AS status_name,
                e.validUpto,
                (
                    SELECT m.vehicle_no
                    FROM manifest m
                    WHERE FIND_IN_SET(pk.id, m.ids)
                    ORDER BY m.id DESC
                    LIMIT 1
                ) AS vehicle_number
            FROM 
                ewaybills e
            LEFT JOIN 
                pickup_entry pk ON pk.ewaybill = e.ewbNo
            LEFT JOIN 
                tbl_branch br ON br.id = pk.branch_id
            LEFT JOIN 
                tbl_status s ON s.id = pk.status_code
            WHERE 
                pk.shipper_name IS NOT NULL 
                AND e.validUpto != ''
                AND s.id NOT IN (5, 7)
                AND e.ewbNo IN (
               201975787479,271975958625,251976088912,201976713080,271976714141,261976739240,211976928070,201976931088,251976947709,201976950926,261976966525,221976976605,261976984093,261976991022,241976993105,251976993418,271977039379,261977061296,251977087736,241977090393,211977100325,271977099766,241977100845,271977103153,271977103252,231977107418,231977113457,241977123433,211977131846,221977169569,291977180433,271977181063,211977184275,251977188282,261977191832,201977203605,281977247818,241977267252,231977273313,251977276066,291977286210,261977288923,251977291001,201977293383,291977299023,261977304005,261977320410,231977325250,281977329174,251977334153,261977336037,221977338862,271977339026,261977342146,221977347280,251977347825,261977349118,201977356334,261977357450,291977363597,251977365236,241977374565,271977374647,241977380588,251977381357,211977386318,201977386414,291977389212,211977391099,201977392523,281977393872,201977394532,241977397603,201977399975,271977401002,261977358958,261977684879,251977788826,231977890211,281977915928,221977918028,251978009854,231978013958,291978023702,281978123195,211978123404,261978126086,291978173812,291978202385,211978027078,291978027241,211978040666,201978175613,231978224183,291978313335,211978359140,211978377452,241978402849,211978410393,281978444926,251978447504,221978452260,271978469153,221978474053,211978476337,291978490430,271978497477,251978502168,281978506028,221978511532,261978512298,231978533104,231978548546,281978551255,241978561236,261978565458,221978568228,231978602839,211978611404,281978612846,291978618470,261978618947,271978629137,201978631467,291978648732,221978649507,201978651746,291978651855,231978652425,271978652922,261978654347,211978654508,281978654567,261978655098,291978655183,221978655434,221978655773,231978655875,221978666593,291978666664,231978667461,291978667740,261978667910,281978669251,201978670837,211978670814,201978672903
)

            HAVING 
                // vehicle_number IS NOT NULL"); 240*/ 
                
                
                
                
                
                
                
                // ["
                // Eway Bill No: 201972060146 failed: You Cannot Extend as EWB can be Extended only 8 hour before or after w.r.t Validity of EWB..!!","
                // Eway Bill No: 241974452554 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261974463127 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 241974489031 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 231974491679 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221974496415 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 281974498480 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 241974510571 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201974519170 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201974525867 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201974539813 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 241974541779 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221974543795 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 291974547868 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261974550362 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211974552644 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271974557407 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975767226 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975770534 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271975772997 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 241975785912 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271975800595 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201975806589 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211975810257 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 231975813827 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251975816822 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975820152 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975853231 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975855842 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975913155 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251975859210 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251975862586 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975866239 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 291975870297 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 281975872894 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211975889062 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 291975925414 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975933070 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 281975943343 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 231975827042 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271975849709 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 241975867038 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 281975869924 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975875347 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201975883368 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975907145 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 281975914071 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975917678 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 231975920594 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 291975941663 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201975944342 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975759739 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251975762468 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975765893 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975767664 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 241975769466 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211975776665 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251975780981 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 281975790103 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975794646 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211975796999 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975798930 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 231975801020 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975803953 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251975806104 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211975809086 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975811424 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975814054 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975817112 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201975819615 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975821481 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211975775620 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975780111 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 291975783094 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201975786281 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211975789478 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271975792768 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271975795965 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211975799084 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975801917 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 231975806971 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 231975816433 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211975819085 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975822552 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975830779 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201975824482 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201975840798 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 291975843033 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 281975856731 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 281975859095 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 281975889386 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271975901137 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271975904107 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251975906107 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 291975911369 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201975917443 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975919827 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251975921874 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 231975840797 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975845351 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975849238 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 291975867059 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201975870500 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271975875171 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975878229 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 231975889589 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201975892702 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211975896088 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 231975899702 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 241975904450 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201975908083 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251975911057 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 291975915626 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975919052 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221975926010 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 281975930783 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 291975934973 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 241975938813 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201975941947 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251975945960 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251975951970 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271976200637 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 281976205594 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251976207997 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201976213225 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 241976216507 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251976218944 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 291976226428 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271976228233 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261976230938 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261976244661 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251976249072 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251976252405 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261976255676 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261976263273 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 291975955130 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 281975967299 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271975969304 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975974280 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261975976356 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211976269362 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 231976272100 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201976274107 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211976278508 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221976281244 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 271976283654 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211976286361 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201976288687 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221976291230 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 241976293641 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251976297691 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221976299742 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 241976301548 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 251976303745 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 211976306630 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 231976308562 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 201976310472 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 221976312263 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 241976314632 failed: Remaining Distance Can not be greater than Actual Distance.","
                // Eway Bill No: 261976316704 failed: Remaining Distance Can not be greater than Actual Distance."]}
                
                
// 241974452554,
// 261974463127,
// 241974489031,
// 231974491679,
// 221974496415,
// 281974498480,
// 241974510571,
// 201974519170,
// 201974525867,
// 201974539813,
// 241974541779,
// 221974543795,
// 291974547868,
// 261974550362,
// 211974552644,
// 271974557407,
// 261975767226,
// 261975770534,
// 271975772997,
// 241975785912,
// 271975800595,
// 201975806589,
// 211975810257,
// 231975813827,
// 251975816822,
// 261975820152,
// 261975853231,
// 221975855842,
// 261975913155,
// 251975859210,
// 251975862586,
// 261975866239,
// 291975870297,
// 281975872894,
// 211975889062,
// 291975925414,
// 261975933070,
// 281975943343,
// 231975827042,
// 271975849709,
// 241975867038,
// 281975869924,
// 261975875347,
// 201975883368,
// 261975907145,
// 281975914071,
// 261975917678,
// 231975920594,
// 291975941663,
// 201975944342,
// 221975759739,
// 251975762468,
// 221975765893,
// 261975767664,
// 241975769466,
// 211975776665,
// 251975780981,
// 281975790103,
// 261975794646,
// 211975796999,
// 221975798930,
// 231975801020,
// 221975803953,
// 251975806104,
// 211975809086,
// 261975811424,
// 221975814054,
// 261975817112,
// 201975819615,
// 261975821481,
// 211975775620,
// 261975780111,
// 291975783094,
// 201975786281,
// 211975789478,
// 271975792768,
// 271975795965,
// 211975799084,
// 261975801917,
// 231975806971,
// 231975816433,
// 211975819085,
// 221975822552,
// 221975830779,
// 201975824482,
// 201975840798,
// 291975843033,
// 281975856731,
// 281975859095,
// 281975889386,
// 271975901137,
// 271975904107,
// 251975906107,
// 291975911369,
// 201975917443,
// 261975919827,
// 251975921874,
// 231975840797,
// 221975845351,
// 221975849238,
// 291975867059,
// 201975870500,
// 271975875171,
// 221975878229,
// 231975889589,
// 201975892702,
// 211975896088,
// 231975899702,
// 241975904450,
// 201975908083,
// 251975911057,
// 291975915626,
// 221975919052,
// 221975926010,
// 281975930783,
// 291975934973,
// 241975938813,
// 201975941947,
// 251975945960,
// 251975951970,
// 271976200637,
// 281976205594,
// 251976207997,
// 201976213225,
// 241976216507,
// 251976218944,
// 291976226428,
// 271976228233,
// 261976230938,
// 261976244661,
// 251976249072,
// 251976252405,
// 261976255676,
// 261976263273,
// 291975955130,
// 281975967299,
// 271975969304,
// 261975974280,
// 261975976356,
// 211976269362,
// 231976272100,
// 201976274107,
// 211976278508,
// 221976281244,
// 271976283654,
// 211976286361,
// 201976288687,
// 221976291230,
// 241976293641,
// 251976297691,
// 221976299742,
// 241976301548,
// 251976303745,
// 211976306630,
// 231976308562,
// 201976310472,
// 221976312263,
// 241976314632,
// 261976316704
// 
                
                
                

                
                
                
                
                
                
                
                
                
                
                
                
                
                
                  
              
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                  
      $stmt = $pdo->prepare("SELECT 
                br.name AS branch_name,
                br.state_code,
                pk.shipper_name,
                pk.shipper_pincode,
                e.ewbNo,
                e.delPinCode,
                e.delStateCode,
                s.name AS status_name,
                e.validUpto,
                (
                    SELECT m.vehicle_no
                    FROM manifest m
                    WHERE FIND_IN_SET(pk.id, m.ids)
                    ORDER BY m.id DESC
                    LIMIT 1
                ) AS vehicle_number
            FROM 
                ewaybills e
            LEFT JOIN 
                pickup_entry pk ON pk.ewaybill = e.ewbNo
            LEFT JOIN 
                tbl_branch br ON br.id = pk.branch_id
            LEFT JOIN 
                tbl_status s ON s.id = pk.status_code
            WHERE 
                e.ewbNo IN (201971091501,201971100315,241972322134,251972325800,281972328949,251972344269,251972346661,251972350758,201972353781,231972358488,231972362728,271972367626,201972370892,271972374051,221972389018,251972396471,201972401978,251972404378,241972415616,221972417799,271972426097,231972428327,221972429471,231972430591,291972432173,231972433798,291972435903,201972437337,211972438391,211972440680,231972447885,221972452352,241972454466,211972456913,201972460119,231972474359,231972477910,241972478242,271972481926,271972483571,261972485178,231972486817,201972489990,251972493420,201972496143,291972514215,211972517603,211972519906,221972523140,221972525951,201972530368,281972538829,221972553402,201972557750,271972566744,221972569355,261972571675,271972583011,211972585626,281972588668,281972590999,251973076316,241973079903,271973082645,251973084674,291973088230,201973091299,221973093303,221973093303,241973173870,291973177062,211973179556,201973182241,251973185274,211973212963,211973213292,251973213038,251973213111,251973213179,291972477781,251972482796,281972485583,261972489170,261972493663,261972499140,281972502473,251972506645,291972510242,201972512803,261972516478,201972528066,291972536842,261974526967,211974538008,201974540873,231974546995,241974549489,231974551957,221974554883,271974557650,291974560724,291974565729,261974568703,211974571074,291974573793,241974597446,281974599246,251975942578,201976448067,271976536488,221976686407,221976723085,201976735860,251977853083,221977670959,231977692084,201977765910,211977767935,221977769682,211977774849,221977776509,221977778071,221977779834,291977781674,231977789849,261977791968,201977793841,251977837409,291977847033,201977856409,221977859389,221977861441,251977863475,281977865649,251977868230,211977870402,221977872612,281977874377,231977876617,241977879648,261977885948,221977887971,291977890251,231977891748,271977892462,231977894383,231977895302,271977898556,271977903243,261977904834,251977905818,231977906732,241977908405,231977910113,281977911418,251977911972,221977914659,291977914634,201977916112,211977917051,221977917476,221977917942,251977917743,201977918374,221977918763,221977918932,271977918557,231977919123,231977919305,241977920397,261977919924,221977927008,261977930011,261977931733,231977932092,241977932037,251977931983,261977933333,281977935179,251977940918,271977945188,281977946395,211977949591,231977949485,231977949513,231977949539,261977949385,291977956975,271977958326,241978151574,281978153626,201978155785,201978158979,291978161213,211978162999,201978167058,281978180231,261978182596,281978184361,201978186516,271978188571,221978194148,241978199107,241978201556,201978203761,201978207354,291978214492,261977932158,261977932231,231978250542,241978252864,211978254267,231978255787,271978257248,221978258738,241978260135,241978261480,241978263080,291978264455,211978265946,261978267356,251978270108,291978273899,231978274948,241978276145,251978277323,211978285551,221978285781,281978285606,291978285708,201978285871,261978286489,271978285955,271978286198,271978286367,291978286251,211978378343,241978382301,221978385049,271978388647,261978392520,291978395812,291978397847,271978398237,211978400617,221978400243,261978402621,271978404435,221978405280,281978407510,281978409420,291978409449,261978411320,251978412007,271978448529,221978450008,291978451747,281978455519,251978463539,281978462803,281978464375,291978466192,291978466882,241978470635,261978469907,261978469907,281978471081,281978473115,241978476000,211978488808,221978493298,251978502452,221978508224,261978509092,281978508529,201978509995,211978509349,201978515583,211978516349,251978516099,281978516564,241978527324,271978529882,211978530365,221978533172,271978536572,211978556457,251978556392,261978569760,261978571400,231981698995,291983066341,241985128561,241985861905,211986040661,291986075104,231986099193,221986103925,211986118645,291986122132,261986137661,221986175940,281986182881,261986195867,251986210237,261986213776,231986286919,271986322398,251986336249,221986345668,281986356150,221986366544,291986373871,201986439080,231986444447,251986444584,241986448286,231986449653,241986449908,221986458614,211986461169,221986486839,211986490866,281986492045,261986492320,271986495294,261986497479,291986506039,281986506276,221986506968,251986507887,201986514853,281986515649,281986521394,211986521827,261986540377,261986544225,211986550160,211986550665,261986553276,211986553789,271986554298,241986554426,281986555207,261986558268,241986559885,201987025552,241987209228,281987216275,221987236981,281987244713,201987252163,211987257046,251987258984,231987259965,281987260339,291987260501,261987260982,241987261765,231987266796,251987268082,281987268627,231987270135,211987271369,211987276124,291987276889,241987277762,271987278917,221987283718,281987285697,281987286335,281987286731,251987377317,241987377707,281987382844,281987383128,211987386478,251987407247,221987408692,261987411720,201987429527,241987430253,221987431276,231987442903,271987448763,221987458796,221987460621,231987461403,281987463082,261987464290,291987470791,221987473801,231987498021,291987530701,231987536983,251987498014,221987538478,231987545624,221987555617,211987595470,271987639312,231987674692,241987675151,261987675764,271987676306,221987701492,241987702983,271987796253,251987801861,241987812154,271987811530,251987841601,281987850552,251987857947,231987861281,281987882117,261987908686,291987911117,261987919480,271987922973,201987925067,211987925718,241987927445,261987928428,221987930067,291987931751,271987933681,251987944942,291987949361,211987951531,221987956216,201987957370,291987964690,281987968590,251987973777,291987974280

                    ) HAVING vehicle_number IS NOT  NULL");          
                
                
                

                
                
                
                
            //      SELECT 
            //     br.name AS branch_name,
            //     br.state_code,
            //     pk.shipper_name,
            //     pk.shipper_pincode,
            //     e.ewbNo,
            //     e.delPinCode,
            //     e.delStateCode,
            //     s.name AS status_name,
            //     e.validUpto,
            //     (
            //         SELECT m.vehicle_no
            //         FROM manifest m
            //         WHERE FIND_IN_SET(pk.id, m.ids)
            //         ORDER BY m.id DESC
            //         LIMIT 1
            //     ) AS vehicle_number
            // FROM 
            //     ewaybills e
            // LEFT JOIN 
            //     pickup_entry pk ON pk.ewaybill = e.ewbNo
            // LEFT JOIN 
            //     tbl_branch br ON br.id = pk.branch_id
            // LEFT JOIN 
            //     tbl_status s ON s.id = pk.status_code
            // WHERE 
            //     pk.shipper_name IS NOT NULL 
            //     AND e.validUpto != ''
            //     AND STR_TO_DATE(SUBSTRING_INDEX(e.validUpto, ' ', 1), '%d/%m/%Y') = STR_TO_DATE('$date', '%d/%m/%Y')
            //     AND s.id NOT IN (5, 7)
            // HAVING 
            //     vehicle_number IS NOT NULL
                
                
                
                
                
    $stmt->execute(); 
    
    $arrayData = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Result containers
    $success_ids = [];
    $failure_ids = [];
    $errors = [];
    
    foreach ($arrayData as $ewbRow) {
        if (empty($ewbRow['ewbNo'])) continue;
    
        $fromPlace = $ewbRow['branch_name'];
        $fromState = $ewbRow['state_code'];
        $ewbNo = $ewbRow['ewbNo'];
        $veh = $ewbRow['vehicle_number'];
        $transMode = 1;
        $extnRsnCode = 4;
        $extnRemarks = 'Transshipment';
        $fromPincode = $ewbRow['shipper_pincode'];
        $consignmentStatus = 'M';
    
        $curl = curl_init();
        $url = $baseUrl . "/ewaybillapi/v1.03/ewayapi/extendvalidity?email=" . urlencode($authemail);
        error_log("cURL URL: " . $url);
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
             CURLOPT_POSTFIELDS =>'{
              "ewbNo": '.$ewbNo.',
              "vehicleNo": "'.$veh.'",
              "fromPlace": "'.$fromPlace.'",
              "fromState": '.$fromState.',
              "remainingDistance": 0,
              "transMode": "1",
              "extnRsnCode": '.$extnRsnCode.',
              "extnRemarks": "'.$reasons.'",
              "fromPincode": '.$fromPincode.',
              "consignmentStatus": "'.$consignmentStatus.'",
              "transitType": "",
              "addressLine1": "",
              "addressLine2": "",
              "addressLine3": ""
            }',
            // CURLOPT_POSTFIELDS => json_encode([
    
                
                
                
            /*{
      "ewbNo": 101011455738,
      "vehicleNo": "ABC1234",
      "fromPlace": "FRAZER TOWN",
      "fromState": 29,
      "remainingDistance": 0,
      "transDocNo": "12",
      "transDocDate": "11/05/2025",
      "transMode": "1",
      "extnRsnCode": 1,
      "extnRemarks": "Nature Calamity",
      "fromPincode": 560001,
      "consignmentStatus": "M",
      "transitType": "",
      "addressLine1": "",
      "addressLine2": "",
      
      
                  "ewbNo" => $ewbNo,
                "vehicleNo" => "'.$veh.'",
                "fromPlace" =>  "'.$fromPlace.'",
                "fromState" =>   $fromState,
                "remainingDistance" => 0,
                "transMode" =>  "'.$transMode.'",
                "extnRsnCode" => $extnRsnCode.'",
                "extnRemarks" =>  "'.$extnRemarks.'",
                "fromPincode" =>   $fromPincode,
                "consignmentStatus" =>  "'.$consignmentStatus
      
      
      */    
                
            // ]),  
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json",
                "Accept: application/json",
                "ip_address: $authip_address",
                "client_id: $authclient_id",
                "client_secret: $authclient_secret",
                "gstin: $authgstin"
            ),
        ));
    
        $response = curl_exec($curl);
        $curl_error = curl_error($curl);
        curl_close($curl);
    
        if ($curl_error) {
            $failure_ids[] = $ewbNo;
            $errors[] = "
            Eway Bill No: $ewbNo failed: cURL Error - $curl_error";
            continue;
        }
    
        $resp = json_decode($response, true);
    
        if (isset($resp['status_cd']) && $resp['status_cd'] == '1') {
            $success_ids[] = $ewbNo;
    
            $ewayBillNo = $resp['data']['ewayBillNo'];
            $validUpto = $resp['data']['validUpto'];
    
            $updateStmt = $pdo->prepare("UPDATE ewaybills SET validUpto = :validUpto WHERE ewbNo = :ewayBillNo");
            $updateStmt->execute([
                ':validUpto' => $validUpto,
                ':ewayBillNo' => $ewayBillNo
            ]);
        } else {
            $failure_ids[] = $ewbNo;
            $errordetails = 'Unknown error';
    
            // Error parsing
            $errorMessage = $resp['error']['message'] ?? '';
            $msg = json_decode($errorMessage, true);
    
            if (json_last_error() === JSON_ERROR_NONE && isset($msg['errorCodes'])) {
                $codes = trim($msg['errorCodes'], ", ");
                $codeArray = explode(",", $codes);
                $Err = [];
    
                foreach ($codeArray as $code) {
                    $stmt = $pdo->prepare("SELECT errorDesc FROM api_error WHERE errorCode = :code");
                    $stmt->execute(['code' => trim($code)]);
                    $ErrData = $stmt->fetch(PDO::FETCH_ASSOC);
                    if ($ErrData && isset($ErrData['errorDesc'])) {
                        $Err[] = $ErrData['errorDesc'];
                    }
                }
    
                if (!empty($Err)) {
                    $errordetails = implode(", ", $Err);
                } else {
                    $errordetails = 'Error code(s) not found in api_error table';
                }
    
            } else {
                // If not JSON or no errorCodes
                $errordetails = is_string($errorMessage) ? $errorMessage : 'Unknown API error format';
            }
    
            // Log error to DB
            $insertStmt = $pdo->prepare("
                INSERT INTO api_ewb_extend_logs (ewbNo, errorDetails) 
                VALUES (:ewbNo, :errorDetails)
            ");
            $insertStmt->execute([
                'ewbNo' => $ewbNo,
                'errorDetails' => $errordetails
            ]);
    
            $errors[] = "
            Eway Bill No: $ewbNo failed: $errordetails";
        }
    }
       
    // Final output
    echo json_encode([
        'status_cd' => count($failure_ids) > 0 ? '0' : '1',
        'success_ids' => $success_ids,
        'failure_ids' => $failure_ids,
        'errors' => $errors
    ]);
    
    error_log(json_encode([
        'status_cd' => count($failure_ids) > 0 ? '0' : '1',
        'success_ids' => $success_ids,
        'failure_ids' => $failure_ids,
        'errors' => $errors
    ]));



}
catch( PDOException $exception ) {
	echo "Connection error :" . $exception->getMessage();
}

?>