<?php
include "inc/config.php";

$track_id = $_REQUEST['track_id'] ?? '';
$type = $_REQUEST['type'] ?? '';
$pick_id = "";

if (empty($track_id) || empty($type)) {
    echo "<script>
        alert('Invalid Shipment track data');
        window.location = 'ui-tracking-venus.php';
    </script>";
    exit;
}

$type_labels = [
    'cscs_awb' => 'CSCS AWB',
    '3pl_awb' => '3PL AWB',
    'ref_no' => 'Ref No'
];

if (!array_key_exists($type, $type_labels)) {
    echo "<script>
        alert('Invalid tracking type.');
        window.location = 'ui-tracking-venus.php';
    </script>";
    exit;
}

$given = $type_labels[$type];

$query = "SELECT * FROM pickup_entry WHERE $type = ?";
$stmt = $pdo->prepare($query);
$stmt->execute([$track_id]);
$result = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$result) {
    echo "<script>
        alert('Incorrect $given Number.');
        window.location = 'ui-tracking-venus.php';
    </script>";
    exit;
}

$pickup = $result[0];
$pick_id = $pickup['id'];

$stmtClient = $pdo->prepare("SELECT * FROM tbl_client_new WHERE id = ?");
$stmtClient->execute([$pickup['new_client_id']]);
$client = $stmtClient->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Shipment Tracking</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        /* Base body and font */
        body {
            background: linear-gradient(135deg, #f0f4f8, #d9e2ec);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
            min-height: 100vh;
            padding-bottom: 3rem;
        }
        h3 {
            font-weight: 700;
            color: #102a43;
            letter-spacing: 0.03em;
            text-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        .btn-secondary {
            background-color: #486581;
            border-color: #486581;
            transition: background-color 0.3s ease, border-color 0.3s ease;
            font-weight: 600;
        }
        .btn-secondary:hover {
            background-color: #334e68;
            border-color: #334e68;
        }
        /* Card styling */
        .card {
            margin-bottom: 2rem;
            border-radius: 1rem;
            box-shadow: 0 12px 20px -10px rgba(16, 42, 67, 0.3);
            background-color: #fff;
            transform-style: preserve-3d;
            animation: fadeSlideIn 0.8s ease forwards;
            border: none;
        }
        .card-header {
            font-weight: 700;
            font-size: 1.3rem;
            letter-spacing: 0.05em;
            border-radius: 1rem 1rem 0 0;
            box-shadow: inset 0 -3px 5px rgb(0 0 0 / 0.1);
            user-select: none;
        }
        .bg-primary {
            background-color: #20639B !important;
            color: #fff !important;
        }
        .bg-info {
            background-color: #3CAEA3 !important;
            color: #fff !important;
        }
        /* Table styling */
        .tracking-table {
            font-size: 14px;
            border-collapse: separate;
            border-spacing: 0 0.8rem;
        }
        .tracking-table th {
            background-color: #fafafa;
            color: #334e68;
            font-weight: 700;
            border: none !important;
            padding: 0.8rem 1.2rem;
            border-radius: 0.5rem;
            user-select: none;
        }
        .tracking-table td {
            background-color: #f7f9fb;
            border: none !important;
            padding: 0.75rem 1.2rem;
            border-radius: 0.5rem;
            vertical-align: middle !important;
            transition: background-color 0.3s ease;
        }
        tbody tr:hover td {
            background-color: #d1e8ff;
            cursor: default;
        }
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .tracking-table th, .tracking-table td {
                font-size: 13px;
                padding: 0.5rem 0.8rem;
            }
        }
        /* Animation */
        @keyframes fadeSlideIn {
            from {
                opacity: 0;
                transform: translateY(20px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }
        /* Container */
        .container {
            max-width: 900px;
        }
        /* Shipment details grid */
        .card-body .row > div {
            padding-bottom: 0.5rem;
        }
    </style>
    <script>
        function printDiv(divName) {
            const printContents = document.getElementById(divName).innerHTML;
            const originalContents = document.body.innerHTML;
            document.body.innerHTML = printContents;
            window.print();
            document.body.innerHTML = originalContents;
        }
    </script>
</head>
<body>
<div class="container mt-4 mb-5">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3>Shipment Tracking</h3>
        <a href="ui-tracking-venus.php" class="btn btn-secondary">Back</a>
    </div>

    <div class="card" id="shipment-details" tabindex="0" aria-label="Shipment details card">
        <div class="card-header bg-primary text-white">
            Shipment Details
        </div>
        <div class="card-body">
            <div class="row gy-2">
                <div class="col-md-4"><strong>AWB No:</strong> <?= htmlspecialchars($pickup['cscs_awb'] ?: $pickup['3pl_awb']) ?></div>
                <div class="col-md-4"><strong>Book Date:</strong> <?= date('d-m-Y', strtotime($pickup['date_added'])) ?></div>
                <div class="col-md-4"><strong>Order Type:</strong> <?= strtoupper(htmlspecialchars($pickup['order_type'])) ?></div>
            </div>
            <div class="row gy-2 mt-2">
                <div class="col-md-4"><strong>Status:</strong> <?= strtoupper(htmlspecialchars($pickup['status'])) ?></div>
                <div class="col-md-4"><strong>Consignee:</strong> <?= htmlspecialchars($pickup['consignee_name']) ?></div>
                <div class="col-md-4"><strong>Address:</strong> <?= htmlspecialchars($pickup['consignee_address']) ?>, <?= htmlspecialchars($pickup['consignee_city']) ?>, <?= htmlspecialchars($pickup['consignee_state']) ?></div>
            </div>
            <div class="row gy-2 mt-2">
                <div class="col-md-4"><strong>Phone:</strong> <?= htmlspecialchars($pickup['consignee_phone']) ?></div>
                <div class="col-md-4"><strong>Pincode:</strong> <?= htmlspecialchars($pickup['consignee_pincode']) ?></div>
                <div class="col-md-4"><strong>Location:</strong> <?= htmlspecialchars($pickup['consignee_location']) ?></div>
            </div>
            <div class="row gy-2 mt-2">
                <div class="col-md-4"><strong>Client Name:</strong> <?= htmlspecialchars($client['name']) ?></div>
                <div class="col-md-4"><strong>Client Phone:</strong> <?= htmlspecialchars($client['phone_no']) ?></div>
                <div class="col-md-4"><strong>Client Location:</strong> <?= htmlspecialchars($client['location']) ?></div>
            </div>
        </div>
    </div>

    <div class="card" id="tracking-history" tabindex="0" aria-label="Tracking history card">
        <div class="card-header bg-info text-white">
            Tracking History
        </div>
        <div class="card-body p-0">
            <table class="table tracking-table mb-0">
                <thead>
                    <tr>
                        <th>S.No</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Location</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $stmtTrack = $pdo->prepare("SELECT * FROM tbl_tracking WHERE pickup_entry_id = ? ORDER BY created_at ASC");
                    $stmtTrack->execute([$pick_id]);
                    $tracks = $stmtTrack->fetchAll(PDO::FETCH_ASSOC);
                    $i = 1;
                    foreach ($tracks as $row):
                        $location = in_array($row['status_code'], [5, 6, 7]) ? $pickup['consignee_city'] : $row['location'];
                        $desc = htmlspecialchars($row['description']) . ' ' . htmlspecialchars($row['location']);
                        if ($row['status_code'] == 7) {
                            $desc .= ' | Delivery date: ' . date('d-m-Y', strtotime($row['delivery_date']));
                        }
                        if (!empty($row['receiver_name'])) {
                            $desc .= ' | Receiver: ' . htmlspecialchars($row['receiver_name']);
                        }
                        if (!empty($row['receiver_mobile'])) {
                            $desc .= ' | Mobile: ' . htmlspecialchars($row['receiver_mobile']);
                        }
                        if (!empty($row['relation'])) {
                            $desc .= ' | Relation: ' . htmlspecialchars($row['relation']);
                        }
                        if (!empty($row['reason'])) {
                            $desc .= ' | Reason: ' . htmlspecialchars($row['reason']);
                        }
                        ?>
                        <tr>
                            <td><?= $i++ ?></td>
                            <td><?= strtoupper(htmlspecialchars($row['status'])) ?></td>
                            <td><?= date('d-m-Y', strtotime($row['created_at'])) ?></td>
                            <td><?= htmlspecialchars($location) ?></td>
                            <td><?= $desc ?></td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($tracks)): ?>
                        <tr><td colspan="5" class="text-center">No tracking history found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
</body>
</html>
