<?php 
ob_start();
session_start();
include "inc/config.php";
include "inc/session.php";
date_default_timezone_set('Asia/Kolkata');

try {                 
    $pickup_entry_id = $_POST['pickup_entry_id']; // Make sure this is sent in POST

    $client_id = ($_POST['client_id'] != '' && $_POST['client_id'] != 'all' && $_POST['client_id'] != '0') ? $_POST['client_id'] : 0;
    $customer_id = ($_POST['customer_id'] != '' && $_POST['customer_id'] != 'all' && $_POST['customer_id'] != '0') ? $_POST['customer_id'] : 0;
    $courier_id = empty($_POST['courier_id']) ? '0' : $_POST['courier_id'];
    $pl3_awb = empty($_POST['3pl_awb']) ? '' : $_POST['3pl_awb'];

    $branch_id = $_POST['branch_id'];

    $pickup_points = $_POST['pickup_points'];
    if ($pickup_points != '' && $pickup_points != 'all' && $pickup_points != '0') {
        $statementss = $pdo->prepare("SELECT * FROM tbl_pickup_points WHERE id=?");
        $statementss->execute([$pickup_points]);
        $resultss = $statementss->fetch();
        $pickup_name = $resultss['name'];
        $pickup_address = $resultss['address'];
        $pickup_pincode = $resultss['pincode'];
        $pickup_city = $resultss['city'];
        $pickup_state = $resultss['state'];
        $pickup_phone = $resultss['mobile_no'];
    } else {
        $pickup_name = $pickup_address = $pickup_pincode = $pickup_city = $pickup_state = $pickup_phone = '';
        $pickup_points = 0;
    }

    $cscs_awb = $_POST['awb_number'];  
    $shipper_location = $_POST['shipper_location'];
    $consignee_location = $_POST['consignee_location'];

    $_POST['invoice_no'] = $_POST['invoice_no'] ?? ''; 
    $_POST['remak'] = $_POST['remak'] ?? '';
    $_POST['material_type'] = $_POST['material_type'] ?? '';

    $statement = $pdo->prepare("UPDATE pickup_entry SET 
        autoGen=?, courier_id=?, client_id=?, cscs_awb=?, status_code=?,
        3pl_awb=?, ref_no=?, order_type=?, boxes=?, collectable_amount=?,
        shipper_name=?, shipper_address=?, shipper_city=?, shipper_state=?, shipper_pincode=?,
        shipper_phone=?, consignee_name=?, consignee_address=?, consignee_city=?, consignee_state=?,
        consignee_pincode=?, consignee_phone=?, product_description=?, quantity=?, invoice_value=?,
        taxable_value=?, hsn_code=?, discount=?, gst_amount=?, mrp=?,
        ewaybill=?, rto_name=?, rto_address=?, rto_city=?, rto_state=?,
        rto_pincode=?, rto_phone=?, a_weight=?, c_weight=?, gst_rate=?,
        buyer_gst=?, seller_gst=?, date_added=?, business_mode=?, business_type=?,
        branch_id=?, pickup_points=?, customer_id=?, pickup_name=?, pickup_address=?,
        pickup_pincode=?, pickup_city=?, pickup_state=?, pickup_phone=?, new_client_id=?,
        consignee_location=?, shipper_location=?, remarks=?, invoice_no=?, material_type=? 
        WHERE id=?
    ");

    $result1 = $statement->execute([
        $_POST['autoGen'], $courier_id, $client_id, $cscs_awb, 1,
        $pl3_awb, $_POST['ref_no'], $_POST['order_type'], $_POST['boxes'], $_POST['collectable_amount'],
        $_POST['shipper_name'], $_POST['shipper_address'], $_POST['shipper_city'], $_POST['shipper_state'], $_POST['shipper_pincode'],
        $_POST['shipper_phone'], $_POST['consignee_name'], $_POST['consignee_address'], $_POST['consignee_city'], $_POST['consignee_state'],
        $_POST['consignee_pincode'], $_POST['consignee_phone'], $_POST['product_description'], $_POST['quantity'], $_POST['invoice_value'],
        $_POST['taxable_value'], $_POST['hsn_code'], $_POST['discount'], $_POST['gst_amount'], $_POST['mrp'],
        $_POST['ewaybill'], $_POST['rto_name'], $_POST['rto_address'], $_POST['rto_city'], $_POST['rto_state'],
        $_POST['rto_pincode'], $_POST['rto_phone'], $_POST['a_weight'], $_POST['c_weight'], $_POST['gst_rate'],
        $_POST['buyer_gst'], $_POST['seller_gst'], $_POST['date_added'], $_POST['pincode_mode'], $_POST['pincode_type'],
        $branch_id, $pickup_points, $customer_id, $pickup_name, $pickup_address,
        $pickup_pincode, $pickup_city, $pickup_state, $pickup_phone, $_POST['new_client'],
        $consignee_location, $shipper_location, $_POST['remak'], $_POST['invoice_no'], $_POST['material_type'],
        $pickup_entry_id
    ]);

    // Optional: update tbl_volumetrix_weight
    if (isset($_POST['length'])) {
        // First delete old entries
        $pdo->prepare("DELETE FROM tbl_volumetrix_weight WHERE pickup_id=?")->execute([$pickup_entry_id]);

        for ($i = 0; $i < count($_POST['length']); $i++) {
            $statement = $pdo->prepare("INSERT INTO tbl_volumetrix_weight(pickup_id, length, width, height, no_of_box, actual_weight, charged_weight, fin_charges_weight) VALUES (?,?,?,?,?,?,?,?)");
            $statement->execute([
                $pickup_entry_id,
                $_POST['length'][$i],
                $_POST['width'][$i],
                $_POST['height'][$i],
                $_POST['no_of_box'][$i],
                $_POST['actual_weight'][$i],
                $_POST['charged_weight'][$i],
                $_POST['final_total_charges'][$i]
            ]);
        }
    }

    if ($result1) {
        $datas[] = array('txt' => "Success..! Shipment Updated", 'error' => 1, 'awb_number' => $cscs_awb, 'p_id' => $pickup_entry_id);
    } else {
        $datas[] = array('txt' => "Failed..! Try Again", 'error' => 0, 'awb_number' => '', 'p_id' => '');
    }

    echo json_encode($datas);
    exit;

} catch (Exception $e) {
    $datas[] = array('txt' => "Something Went Wrong", 'error' => 0, 'awb_number' => '', 'p_id' => '');
    echo json_encode($datas);
    exit;
}
?>
