<?php
class custom_functions
{
    function xss_clean_array($array)
    {
        if (is_array($array)) {
            foreach ($array as $key => $value) {
                $array[$key] = $this->xss_clean($value);
            }
        } else {
            $array = $this->xss_clean($array);
        }
        return $array;
    }

    function xss_clean($data)
    {
        $data = trim($data);
        // Fix &entity\n;
        $data = str_replace(array('&amp;', '&lt;', '&gt;'), array('&amp;amp;', '&amp;lt;', '&amp;gt;'), $data);
        $data = preg_replace('/(&#*\w+)[\x00-\x20]+;/u', '$1;', $data);
        $data = preg_replace('/(&#x*[0-9A-F]+);*/iu', '$1;', $data);
        $data = html_entity_decode($data, ENT_COMPAT, 'UTF-8');

        // Remove any attribute starting with "on" or xmlns
        $data = preg_replace('#(<[^>]+?[\x00-\x20"\'])(?:on|xmlns)[^>]*+>#iu', '$1>', $data);

        // Remove javascript: and vbscript: protocols
        $data = preg_replace('#([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`\'"]*)[\x00-\x20]*j[\x00-\x20]*a[\x00-\x20]*v[\x00-\x20]*a[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2nojavascript...', $data);
        $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*v[\x00-\x20]*b[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2novbscript...', $data);
        $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*-moz-binding[\x00-\x20]*:#u', '$1=$2nomozbinding...', $data);

        // Only works in IE: <span style="width: expression(alert('Ping!'));"></span>
        $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?expression[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
        $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?behaviour[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
        $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:*[^>]*+>#iu', '$1>', $data);

        // Remove namespaced elements (we do not need them)
        $data = preg_replace('#</*\w+:\w[^>]*+>#i', '', $data);

        do {
            // Remove really unwanted tags
            $old_data = $data;
            $data = preg_replace('#</*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|i(?:frame|layer)|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|title|xml)[^>]*+>#i', '', $data);
        } while ($old_data !== $data);

        // we are done...
        return $data;
    }
    
    
    function get_ai_id($pdo,$tbl_name) 
    {
    	$statement = $pdo->prepare("SHOW TABLE STATUS LIKE '$tbl_name'");
    	$statement->execute();
    	$result = $statement->fetchAll(PDO::FETCH_ASSOC);
    	foreach($result as $row)
    	{
    		$next_id = $row['Auto_increment'];
    	}
    	return $next_id;
    }
    function get_order_id($pdo){
        $six_digit_random_number = random_int(10000, 99999);
        
        $statement = $pdo->prepare("SHOW TABLE STATUS LIKE 'shipment'");
    	$statement->execute();
    	$result = $statement->fetchAll(PDO::FETCH_ASSOC);
    	foreach($result as $row)
    	{
    		$next_id = $row['Auto_increment'];
    	}
    	return $six_digit_random_number.$next_id;
    }



    function get_status_code($status_name){
        switch(strtolower(preg_replace('/\s*/', '', $status_name))){
            case "pending":
                    return 2;
                    break;
            case "picked":
                    return 3;
                    break;
            case "manifest":
                    return 4;
                    break;
            case "intransit":
                    return 5;
                    break;
            case "receivedatdestination":
                    return 6;
                    break;
            case "outfordelivery":
                    return 7;
                    break;        
            case "delivered":
                    return 8;
                    break;
            case "undelivery":
                    return 9;
                    break;
            case "returntoorigin":
                    return 10;
                    break;
            case "missing":
                    return 11;
                    break;
            case "lost":
                    return 12;
                    break;
            case "damage":
                    return 13;
                    break;
            default:
                return 0;
                break;
        }
    }
    
    function get_status_name($status_code){
        switch(strtolower(preg_replace('/\s*/', '', $status_code))){
            case 1:
                    return 'Booked';
                    break;
            case 2:
                    return 'Ready To Ship';
                    break;
            case 3:
                    return 'Picked';
                    break;
            case 4:
                    return 'Manifest';
                    break;
            case 5:
                    return 'In-Transit';
                    break;
            case 6:
                    return 'Received At Destination';
                    break;
            case 7:
                    return 'Out For Delivery';
                    break;        
            case 8:
                    return 'Delivery';
                    break;
            case 9:
                    return 'Un-Delivery';
                    break;
            case 10:
                    return 'Return to Origin';
                    break;
            case 11:
                    return 'Missing';
                    break;
            case 12:
                    return 'Lost';
                    break;
            case 13:
                    return 'Damage';
                    break;
            default:
                return 'Un-Known';
                break;
        }
    }


    function gen_uuid() {
    return sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        // 32 bits for "time_low"
        mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ),

        // 16 bits for "time_mid"
        mt_rand( 0, 0xffff ),

        // 16 bits for "time_hi_and_version",
        // four most significant bits holds version number 4
        mt_rand( 0, 0x0fff ) | 0x4000,

        // 16 bits, 8 bits for "clk_seq_hi_res",
        // 8 bits for "clk_seq_low",
        // two most significant bits holds zero and one for variant DCE1.1
        mt_rand( 0, 0x3fff ) | 0x8000,

        // 48 bits for "node"
        mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff )
    );
}


function randomPassword() {
    $alphabet = "ABCDEFGHIJKLMNOPQRSTUWXYZ0123456789";
    $pass = array(); //remember to declare $pass as an array
    $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
    for ($i = 0; $i < 8; $i++) {
        $n = rand(0, $alphaLength);
        $pass[] = $alphabet[$n];
    }
    return implode($pass); //turn the array into a string
}


}

?>