<?php

ob_start();
session_start();
include("../inc/config.php");
include("../inc/session.php");
?>
<?php

    $now = gmdate("YmdHis");
	header('Content-Type: text/csv; charset=utf-8');  
	header('Content-Disposition: attachment; filename=DRS-Report.csv');  
	$output = fopen("php://output", "w"); 
	
	
	
	function xss_clean($data)
    {
        $data = trim($data);
        // Fix &entity\n;
        $data = str_replace(array('&amp;', '&lt;', '&gt;'), array('&amp;amp;', '&amp;lt;', '&amp;gt;'), $data);
        $data = preg_replace('/(&#*\w+)[\x00-\x20]+;/u', '$1;', $data);
        $data = preg_replace('/(&#x*[0-9A-F]+);*/iu', '$1;', $data);
        $data = html_entity_decode($data, ENT_COMPAT, 'UTF-8');

        // Remove any attribute starting with "on" or xmlns
        $data = preg_replace('#(<[^>]+?[\x00-\x20"\'])(?:on|xmlns)[^>]*+>#iu', '$1>', $data);

        // Remove javascript: and vbscript: protocols
        $data = preg_replace('#([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`\'"]*)[\x00-\x20]*j[\x00-\x20]*a[\x00-\x20]*v[\x00-\x20]*a[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2nojavascript...', $data);
        $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*v[\x00-\x20]*b[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2novbscript...', $data);
        $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*-moz-binding[\x00-\x20]*:#u', '$1=$2nomozbinding...', $data);

        // Only works in IE: <span style="width: expression(alert('Ping!'));"></span>
        $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?expression[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
        $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?behaviour[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
        $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:*[^>]*+>#iu', '$1>', $data);

        // Remove namespaced elements (we do not need them)
        $data = preg_replace('#</*\w+:\w[^>]*+>#i', '', $data);

        do {
            // Remove really unwanted tags
            $old_data = $data;
            $data = preg_replace('#</*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|i(?:frame|layer)|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|title|xml)[^>]*+>#i', '', $data);
        } while ($old_data !== $data);

        // we are done...
        return $data;
    }
    
    $condition = '';

 
    $branch_id = $_POST['branch_id'] ?? 0;
    $driver_id=$_POST['driver_id'] ?? 0;
    $delivery_boy_id=$_POST['delivery_boy_id'] ?? 0;
   
    if($branch_id!='all' && $branch_id!=''){
        $condition.=" and dr.branch_id='".$branch_id."'";
    }
    
    if($driver_id!='all' && $driver_id!=''){
        $condition.=" and dr.driver_id='".$driver_id."'";
    }
    if($delivery_boy_id!='all' && $delivery_boy_id!=''){
        $condition.=" and dr.delivery_boy_id='".$delivery_boy_id."'";
    }
    
	
	
	$statement = $pdo->prepare(" SELECT dr.*,pickup_entry.*,SUM(pickup_entry.c_weight) AS total_c_weight, SUM(pickup_entry.a_weight) AS total_a_weight,b.name as 'branch_name',
	                            COUNT(CASE WHEN pickup_entry.status_code = '5' THEN 1 END) AS delivery_count,
                                COUNT(CASE WHEN pickup_entry.status_code != '5' THEN 1 END) AS pending_count,
                                COUNT(CASE WHEN pickup_entry.pod_status = 'Not Updated' THEN 1 END) AS pod_not_update_count
                                FROM tbl_delivery_run_sheet AS dr 
                                LEFT JOIN pickup_entry ON FIND_IN_SET(pickup_entry.id, dr.shipment_ids) > 0 
                                LEFT JOIN tbl_branch AS b ON b.id = dr.branch_id
                                WHERE 1=1 $condition GROUP BY dr.id");    
    $statement->execute();
	$query = $statement->fetchAll(PDO::FETCH_ASSOC);
	$totalData = $statement->rowCount();
	
	    $i =1;
	   /*Fetch Filter Data End*/
        fputcsv($output, array('S NO'.'DRS CODE','DRIVER NAME','DRIVER MOBILE NUMBER','VEHICLE NUMBER','DELIVERY BOY NAME','DELIVERY BOY MOBILE NUMBER','ACTUAL WEIGHT','CHARGED WEIGHT','BRANCH NAME','TOTAL SHIPMENT','DRS DATE','STATUS','DELIVERY COUNT','PENDING COUNT','POD NOT UPDATED'));
        foreach($query as $row ) { 
            
            $status="Closed";
	if($row['delivery_count']!=$row["shipment_count"]){ $status="Pending";}
            fputcsv($output, array($i,$row['drs_no'],$row['driver_name'],$row['driver_mobile_no'],$row['vehicle_no'],strtoupper($row['delivery_boy_name']),$row['delivery_boy_mobile_no'],$row['total_a_weight'],$row['total_c_weight'],$row['branch_name'],$row['shipment_count'],date('d M Y',strtotime($row['date'])),$status,$row['delivery_count'],$row['pending_count'],$row['pod_not_update_count']));
            
            $i++;
        }
   
   	fclose($output);
	
	
?>