<?php 
ob_start();
session_start();
include("../inc/config.php");
include("../inc/session.php");
?>
<?php

    $now = gmdate("YmdHis");
	header('Content-Type: text/csv; charset=utf-8');  
	header('Content-Disposition: attachment; filename=Delivery-Pending-Report.csv');  
	$output = fopen("php://output", "w"); 


function xss_clean($data)
    {
        $data = trim($data);
        // Fix &entity\n;
        $data = str_replace(array('&amp;', '&lt;', '&gt;'), array('&amp;amp;', '&amp;lt;', '&amp;gt;'), $data);
        $data = preg_replace('/(&#*\w+)[\x00-\x20]+;/u', '$1;', $data);
        $data = preg_replace('/(&#x*[0-9A-F]+);*/iu', '$1;', $data);
        $data = html_entity_decode($data, ENT_COMPAT, 'UTF-8');

        // Remove any attribute starting with "on" or xmlns
        $data = preg_replace('#(<[^>]+?[\x00-\x20"\'])(?:on|xmlns)[^>]*+>#iu', '$1>', $data);

        // Remove javascript: and vbscript: protocols
        $data = preg_replace('#([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`\'"]*)[\x00-\x20]*j[\x00-\x20]*a[\x00-\x20]*v[\x00-\x20]*a[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2nojavascript...', $data);
        $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*v[\x00-\x20]*b[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:#iu', '$1=$2novbscript...', $data);
        $data = preg_replace('#([a-z]*)[\x00-\x20]*=([\'"]*)[\x00-\x20]*-moz-binding[\x00-\x20]*:#u', '$1=$2nomozbinding...', $data);

        // Only works in IE: <span style="width: expression(alert('Ping!'));"></span>
        $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?expression[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
        $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?behaviour[\x00-\x20]*\([^>]*+>#i', '$1>', $data);
        $data = preg_replace('#(<[^>]+?)style[\x00-\x20]*=[\x00-\x20]*[`\'"]*.*?s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:*[^>]*+>#iu', '$1>', $data);

        // Remove namespaced elements (we do not need them)
        $data = preg_replace('#</*\w+:\w[^>]*+>#i', '', $data);

        do {
            // Remove really unwanted tags
            $old_data = $data;
            $data = preg_replace('#</*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|i(?:frame|layer)|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|title|xml)[^>]*+>#i', '', $data);
        } while ($old_data !== $data);

        // we are done...
        return $data;
    }


$requestData= $_REQUEST;

$condition = '';

    $from_date=$_POST['from_date'] ?? date('Y-m-d');
    $to_date=$_POST['to_date'] ?? date('Y-m-d');
    $new_client = $_POST['new_client'] ?? 0;
    $branch_id=$_POST['branch_id'] ?? 0;
    $client_id=$_POST['client_id'] ?? 0;
    $courier_id=$_POST['courier_id'] ?? 0;
    $customer_id=$_POST['customer_id'] ?? 0;
    $status=$_POST['status'] ?? 0;
    

    $condition.=" and pickup_entry.date_added BETWEEN '$from_date' AND '$to_date'  ";
    if($branch_id!='all' && $branch_id!=''){
        $condition.=" and pickup_entry.branch_id='".$branch_id."'";
    }
    
    if($new_client!='all' && $new_client!=''){
        $condition.=" and pickup_entry.new_client_id='".$new_client."'";
    }
    if($client_id!='all' && $client_id!=''){
        $condition.=" and pickup_entry.client_id='".$client_id."'";
    }
    if($courier_id!='all' && $courier_id!=''){
        $condition.=" and pickup_entry.courier_id='".$courier_id."'";
    }
    if($customer_id!='all' && $customer_id!=''){
        $condition.=" and pickup_entry.customer_id='".$customer_id."'";
    }
    if($status!='all'){
        $condition.=" and pickup_entry.status_code='".$status."'";
    }
    
    if($session_client_ids==0){
        $condition.="";
    }else{
        $condition.=" and tbl_client_new.id IN ($session_client_ids)";
    }
    
     if($session['id']!=1 && $session_branch_ids!='0'){
        $condition.= " and tbl_branch.id IN ($session_branch_ids)";
    }
    
      $condition.=" and pickup_entry.status_code !='5'";

        
        
        
    $statement = $pdo->prepare("SELECT pickup_entry.*,tbl_client_new.name as new_client_name,tbl_user.full_name as client_name,tbl_status.name as status_name FROM `pickup_entry` 
    left JOIN tbl_user ON pickup_entry.client_id=tbl_user.id 
    left join tbl_branch on pickup_entry.branch_id=tbl_branch.id 
    left JOIN tbl_status ON tbl_status.id=pickup_entry.status_code 
    left JOIN tbl_client_new ON tbl_client_new.id=pickup_entry.new_client_id
    WHERE 1=1  $condition  ORDER BY pickup_entry.id DESC");    
    $statement->execute();
	$query = $statement->fetchAll(PDO::FETCH_ASSOC);
	$totalData = $statement->rowCount();
    $totalFiltered = $totalData;  
    /*Fetch Data Endss*/   
    
    fputcsv($output, array('S NO','DATE','AWB NO','BRANCH','CLIENT NAME','SHIPMENT STATUS','SENDER NAME','SENDER LOCATION','SENDER PINODE','SENDER CITY','SENDER STATE','SENDE PHONE','RECEIVER NAME','RECEIVER LOCATION','RECEIVER PINCODE','RECEIVER CITY','RECEIVER STATE','RECEIVER PHONE'));
        
        $i =1;
        
        foreach($query as $row ) { 
            fputcsv($output, array($i,date('d-m-Y',strtotime($row['date_added'])),$row['cscs_awb'],$row['branch_name'],$row['new_client_name'],$row['status_name'],$row['shipper_name'],$row['shipper_location'],$row['shipper_pincode'],$row['shipper_city'],$row['shipper_state'],$row['shipper_phone'],$row['consignee_name'],$row['consignee_location'],$row['consignee_pincode'],$row['consignee_city'],$row['consignee_state'],$row['consignee_phone']));
            
            $i++;
        }
   
   	fclose($output);



?>
        