<?php 
ob_start();
session_start();
include "../inc/config.php";
include "../inc/session.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo->beginTransaction();

        // Extracting Pickup Entry Data
        $pickup_id = $_POST['pickup_id'] ?? null;
        $product_description = $_POST['product_description'] ?? '';
        $quantity = $_POST['quantity'] ?? '';
        $taxable_value = $_POST['taxable_value'] ?? '';
        $ewaybill = $_POST['ewaybill'] ?? '';
        $document_number = $_POST['document_number'] ?? '';
        $boxes = $_POST['boxes'] ?? '';
        $a_weight = $_POST['a_weight'] ?? '';
        $c_weight = $_POST['c_weight'] ?? '';

        // Update Pickup Entry
        if ($pickup_id) {
            $sql = "UPDATE pickup_entry 
                    SET product_description = ?, quantity = ?, taxable_value = ?, ewaybill = ?, 
                        document_number = ?, boxes = ?, a_weight = ?, c_weight = ? 
                    WHERE id = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$product_description, $quantity, $taxable_value, $ewaybill, $document_number, $boxes, $a_weight, $c_weight, $pickup_id]);
        }

        // Handling Volumetrix Weight Entries
        if (!empty($_POST['volumetrix_data'])) {
            $volumetrix_data = json_decode($_POST['volumetrix_data'], true);
            
            foreach ($volumetrix_data as $item) {
                $id = $item['ids'] ?? null;
                $length = $item['length'] ?? '';
                $width = $item['width'] ?? '';
                $height = $item['height'] ?? '';
                $no_of_box = $item['no_of_box'] ?? '';
                $actual_weight = $item['actual_weight'] ?? '';
                $charged_weight = $item['charged_weight'] ?? '';
                $final_total_charges = $item['final_total_charges'] ?? '';

                if ($id) {
                    // Update Existing Record
                    $sql = "UPDATE tbl_volumetrix_weight 
                            SET length = ?, width = ?, height = ?, no_of_box = ?, 
                                actual_weight = ?, charged_weight = ?, fin_charges_weight = ? 
                            WHERE id = ?";
                    $stmt = $pdo->prepare($sql);
                    $stmt->execute([$length, $width, $height, $no_of_box, $actual_weight, $charged_weight, $final_total_charges, $id]);
                } else {
                    // Insert New Record
                    $sql = "INSERT INTO tbl_volumetrix_weight 
                            (length, width, height, no_of_box, actual_weight, charged_weight, fin_charges_weight,pickup_id) 
                            VALUES (?, ?, ?, ?, ?, ?, ?,?)";
                    $stmt = $pdo->prepare($sql);
                    $stmt->execute([$length, $width, $height, $no_of_box, $actual_weight, $charged_weight, $final_total_charges,$pickup_id]);
                }
            }
        }

        $pdo->commit();
        echo json_encode(["status" => "success", "message" => "Data updated successfully."]);
    } catch (Exception $e) {
        $pdo->rollBack();
        echo json_encode(["status" => "error", "message" => $e->getMessage()]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method."]);
}
?>
