<?php
ob_start();
session_start();
include "../inc/config.php";
include "../inc/session.php";

if (isset($_POST['awb_numbers']) && is_array($_POST['awb_numbers'])) {
    $awb_numbers = $_POST['awb_numbers'];
    $placeholders = implode(',', array_fill(0, count($awb_numbers), '?'));

    $statement = $pdo->prepare("SELECT id, cscs_awb  FROM pickup_entry WHERE cscs_awb IN ($placeholders)");
    $statement->execute($awb_numbers);
    $results = $statement->fetchAll(PDO::FETCH_ASSOC);

    $found_ids = [];
    $found_awbs = [];
    foreach ($results as $row) {
        $found_ids[] = (int)$row['id'];
        $found_awbs[] = $row['cscs_awb'];
    }

    $not_found_awbs = array_diff($awb_numbers, $found_awbs);

    echo json_encode([
        'error' => false,
        'ids' => $found_ids,
        'not_found' => array_values($not_found_awbs)
    ]);
} else {
    echo json_encode([
        'error' => true,
        'message' => 'Invalid input.'
    ]);
}
?> 