<?php require_once('header.php'); ?>
<?php if($allPermissions['logistics']['read']=="1"){ ?>

<section class="content-header">
	<div class="content-header-left">
		<h1>View Courier Companies</h1>
	</div>
	
	<?php if($allPermissions['logistics']['create']=="1"){ ?>
	<div class="content-header-right">
		<a href="courier_company-add.php" class="btn btn-danger btn-sm">Add New Courier Company</a>
	</div>
	<?php } ?>
</section>
<section class="content">
	<div class="row">
		<div class="col-md-12">
			<div class="box box-info">
				<div class="box-body table-responsive">
					<table id="example1" class="table table-bordered table-striped">
						<thead>
							<tr>
								<th width="30">SL</th>
								<th>Company Code</th>
								<th>Company Name</th>
								<th>Company Description</th>
								<th>Last Updated</th>
								<th>Action</th>
							</tr>
						</thead>
						<tbody>
							<?php
							$i=0;
							$statement = $pdo->prepare("SELECT * FROM courier_company");
							$statement->execute();
							$result = $statement->fetchAll(PDO::FETCH_ASSOC);
							foreach ($result as $row) {
								$i++;
								?>
								<tr>
									<td><?php echo $i; ?></td>
									<td><?php echo $row['id']; ?></td>
									<td><?php echo $row['company_name']; ?></td>
									<td><?php echo $row['company_description']; ?></td>
									<td><?php $day=date_create($row['updated_at']);
									    $date=date_format($day,'d-m-Y');
									    echo $date; ?></td>
									<td>										
									<?php if($allPermissions['logistics']['update']=="1"){ ?>	<a href="courier_company-edit.php?id=<?php echo $row['id']; ?>" class="btn btn-danger btn-xs">Edit</a><?php } ?>
	<?php if($allPermissions['logistics']['delete']=="1"){ ?>	<?php if($row['id']!=7){ ?><a href="#" class="btn btn-success btn-xs" data-href="courier_company-delete.php?id=<?php echo $row['id']; ?>" data-toggle="modal" data-target="#confirm-delete">Delete</a>  <?php } } ?>
									</td>
								</tr>
								<?php
							}
							?>							
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>


</section>


<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h4 class="modal-title" id="myModalLabel">Delete Confirmation</h4>
            </div>
            <div class="modal-body">
                <p>Are you sure want to delete this item?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a class="btn btn-danger btn-ok">Delete</a>
            </div>
        </div>
    </div>
</div>
<?php }else{ ?>
<center><h4 style="color:red;">You don't have permission to view logistics </h4></center>
<?php } ?>

<?php require_once('footer.php'); ?>