<?php 
ob_start();
session_start();
include "../inc/config.php";
$today_date = date('Y-m-d');

header('Content-Type: application/json');

$ewaybill_number = $_POST['ewaybill_number'] ?? '';

if (empty($ewaybill_number)) {
    echo json_encode(['status' => 'error', 'message' => 'Missing number']);
    exit;
}

// ✅ PDO connection
try {

    $stmt = $pdo->prepare("SELECT 1 FROM ewaybills WHERE ewbNo  = :ewaybill_number LIMIT 1");
    $stmt->execute(['ewaybill_number' => $ewaybill_number]);

    if ($stmt->fetch()) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Not found']);
    }

} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'DB Error']);
}
?>
